package devices;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

import centralSystem.ICentralSystem;

public class ClientButtonFrame extends JFrame{

	private ICentralSystem centralSys;

	public ClientButtonFrame(ICentralSystem centralSys) { 
		super("Poste Italiane - Prenotazione Servizi");
		this.centralSys = centralSys;
		JPanel panel = new JPanel();
		panel = this.buildPanel();
		super.getContentPane().add(panel);
		super.setSize(500, 50);
		super.setResizable(false);
		super.setVisible(true);
		super.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	private JPanel buildPanel() {
		JPanel panel = new JPanel();
		panel.setLayout(new GridLayout(1, 3));
		JButton button1 = new JButton("Servizi Postali");
		JButton button2 = new JButton("Servizi Finanzari");
		JButton button3 = new JButton("Altri Servizi");
		button1.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				centralSys.addClientAtQueue(0);
			}
		});
		button2.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				centralSys.addClientAtQueue(1);
			}
		});
		button3.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				centralSys.addClientAtQueue(2);
			}
		});
		panel.add(button1);
		panel.add(button2);
		panel.add(button3);
		return panel;
	}

}
